<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Validator;
use Mail;
class MailController extends Controller
{
    public function mail( Request $request)
    {
        $validator = Validator::make($request->all(), [
            'text' => 'required',
            'email' => 'required|email',
            'subject' => 'required',
        ]);
   
        if($validator->fails()){
             
            return  response()->json([$validator->errors(), 400],400);    
        }
        $data["email"] = $request->email;
        $data["body"] = $request->text;
        $data["title"]= $request->subject;
        
        Mail::send('mail', $data, function($message)use($data) {
            $message->to($data["email"], $data["email"])
                    ->subject($data["title"]);
 
            
        });
        return  response()->json(['success', 201],201); 
    }
}
