<?php

namespace App\Http\Controllers;

use App\Models\Service;
use App\Models\User;
use Illuminate\Http\Request;
use App\Http\Resources\ServiceResource;
use App\Models\Companies;

class SearchController extends Controller
{
    public function search($desc)
    {
        $result1 = Service::where('description', 'like', '%' . $desc . '%')->get();
        $result2 = Service::where('keywords', 'like', '%' . $desc . '%')->get();
        $results = $result1->merge($result2);

        if (count($results)) {
            foreach ($results as  $result) {
                $User = User::find($result->user_id);
                $Company = User::find($User->id)->company;
                $result->user_name = $User->first_name . ' ' . $User->last_name;
                $result->company_name = $Company->company_name;
                $result->city = $Company->city;
            }
            return $results;
        }
    }
    public function services($id)
    {
        $Services = User::find($id)->services;
        return ServiceResource::collection($Services);
    }
    public function service_user($id)
    {
        $User = Service::find($id)->user;
        $Company = User::find($User->id)->company;
        return ['company_email' => $Company->company_email, 'company_phone' => $Company->company_telephone, 'user_email' => $User->email];
    }
    public function update_company(Request $request)
    {
        Companies::where('id', $request->id)->update($request->all());
        return Companies::find($request->id);
    }
    public function update_user(Request $request)
    {
        User::where('id', $request->id)->update($request->all());
        return User::find($request->id);
    }
    public function update_user_password(Request $request)
    {
        if ($request->password != '') {
            $user = User::find($request->id);
            $user->first_name = $request->first_name;
            $user->last_name = $request->last_name;
            $user->email = $request->email;
            $user->password = bcrypt($request->password);
            $user->save();
            return $user;
        }
    }
}
