<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class MailClass extends Mailable
{
    use Queueable, SerializesModels;
    protected $name='name';
    protected $email;
    protected $message;
    protected $subject;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($subject,$email,$message)
    {
        $this->subject = $subject;
        $this->email = $email;
        $this->message = $message;

    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->view('view.name') ->with([
            'name' => $this->name,
            'email' => $this->email,
            'message' => $this->message,
        ])
        ->subject($this->subject);
    }
}
