<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::group([
    'prefix' => 'auth'
], function () {
    Route::post('login', [App\Http\Controllers\Auth\AuthController::class, 'login'])->name('login');
    Route::post('register', [App\Http\Controllers\Auth\AuthController::class, 'register'])->name('register');
    Route::post('reset-password', [App\Http\Controllers\Auth\AuthController::class, 'sendEmail'])->name('reset-password');
    Route::group([
        'middleware' => 'auth:api'
    ], function () {
        Route::get('user', [App\Http\Controllers\Auth\AuthController::class, 'user'])->name('user');
        Route::get('logout', [App\Http\Controllers\Auth\AuthController::class, 'logout'])->name('logout');
    });
});

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});
Route::post('email',[App\Http\Controllers\MailController::class,'mail'])->name('email');
Route::get('search/{desc}',[App\Http\Controllers\SearchController::class,'search'])->name('search');
Route::get('user-services/{id}',[App\Http\Controllers\SearchController::class,'services'])->name('services');
Route::get('service-user/{id}',[App\Http\Controllers\SearchController::class,'service_user'])->name('service-user');
Route::patch('update-company',[App\Http\Controllers\SearchController::class,'update_company'])->name('update-company');
Route::patch('update-user',[App\Http\Controllers\SearchController::class,'update_user'])->name('update-user');
Route::patch('update-user-password',[App\Http\Controllers\SearchController::class,'update_user_password'])->name('update-user-password');
Route::apiResource('services',App\Http\Controllers\Api\ServicesController::class);
Route::middleware('web')->get('resetPassword/{token}', ['as' => 'resetPassword', function($token)
{
   return view('auth.passwords.reset')->with('token', $token); 
}]);